<h1>API Key</h1>
<hr>
<?php if($saved){ ?>
    <div class="notice notice-success">
        <p>Your API key was saved successfully. You can now start using Metals API with the shortcodes.</p>
    </div>
<?php } ?>
<form class="" method="post">
    <?php wp_nonce_field(-1, "thenonce");?>
    <table class="form-table">
        <tbody>
            <tr>
                <th>Metals API Key</th>
                <td>
                    <input type="text" name="metalapi_apikey" value="<?php echo esc_attr(get_option('metalapi_apikey')); ?>" class="large-text" style="width: 100%; max-width: 600px;">
                    <p class="description">API status: <span><?php echo isset($metalapi_error) && trim($metalapi_error) != "" ? esc_html($metalapi_error) : "Not used yet"; ?></span></p>
                    <p class="description">You can get your API key by registering at <a href="https://metals-api.com" target="_blank">https://metals-api.com</a> and view pricing at <a href="https://metals-api.com/pricing" target="_blank">https://metals-api.com/pricing</a>. After you sign up, please copy "Your API Access Key" on the dashboard section.</p>
                </td>
            </tr>
        </tbody>
    </table>
    <p>
        <button type="submit" class="button button-primary" name="save">Save API Key</button>
    </p>
</form>